<?php
if (!function_exists('abw_render_youtube_shortcode')) {

    add_shortcode('abw_yt', 'abw_render_youtube_shortcode');

    function abw_render_youtube_shortcode($attributes)
    {

        wp_enqueue_script(
            'abw-ssd-video-optin',
            plugin_dir_url(__DIR__) . 'js/video_loader_appbisweb-min.js',
            array(),
            null,
            true
        );

        $ssd_banner_default = "";
        require_once(plugin_dir_path(__DIR__) . '../admin/partials/default_options.php');
        $defaults = $ssd_banner_default;

        wp_localize_script(
            'abw-ssd-video-optin',
            'videoConfig',
            array(
                "text"              => default_or_user_value('ssd_legal_text_videos', $defaults),
                "btnText"              => default_or_user_value('ssd_video_btn_title', $defaults),
                "premium"           => abw_ssd_checkIfPremium(get_option('ssd_licence_code')),
                "removeBranding"    => get_option('ssd_remove_branding'),
                "titleColor"             => get_option('ssd_title_color'),
                "textColor"             => get_option('ssd_text_color'),
                "btnTextColor"             => get_option('ssd_btn_text_color'),
                "btnTextHoverColor"     => get_option('ssd_btn_text_hover_color'),
                "btnColor"                 => get_option('ssd_btn_color'),
                "btnHoverColor"         => get_option('ssd_btn_hover_color'),
                "domain"                => get_home_url()
            )
        );


        $id = $attributes['id'];
        $w = "";
        $h = "";

        $width_style = "";
        $height_style = "";
        $portrait_style = "";

        if (in_array('hochformat', $attributes)) {
            $portrait_style = "aw_portrait";
        }

        if (isset($attributes['w'])) {
            $w = $attributes['w'];
            $width_style = 'width:' . $w . 'px !important;';
        }

        if (isset($attributes['h'])) {
            $h = $attributes['h'];
            $height_style = 'height:' . $h . 'px !important;';
        }

        // error_log($height_style);



        return '<div class="aw_video_wrap ' . $portrait_style . '" data-video-id="' . $id . '" data-vwidth="' . $w . '" data-vheight="' . $h . '" style="' . $width_style . '' . $height_style . '"></div>';
    }
}
