<?php
if (!is_user_logged_in()) {
    function addConsentAnalytics()
    {
        $gaId = get_option('ssd_ga_id');
?>

        <script async src="https://www.googletagmanager.com/gtag/js?id=<?php echo $gaId; ?>"></script>
        <script>
            window.dataLayer = window.dataLayer || [];

            function gtag() {
                dataLayer.push(arguments);
            }

            gtag('consent', 'default', {
                'ad_storage': 'denied',
                'analytics_storage': 'denied'
            });

            gtag('js', new Date());
            gtag('config', '<?php echo $gaId; ?>', {
                'anonymize_ip': true
            });
        </script>

<?php
    }
    add_action('wp_head', 'addConsentAnalytics');
}
