<?php

/**
 * The public-facing functionality of the plugin.
 *
 * @link       https://app-bis-web.de
 * @since      1.0.0
 *
 * @package    Abw_ss_dsgvo
 * @subpackage Abw_ss_dsgvo/public
 */

/**
 * The public-facing functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the public-facing stylesheet and JavaScript.
 *
 * @package    Abw_ss_dsgvo
 * @subpackage Abw_ss_dsgvo/public
 * @author     Jan Luther <info@app-bis-web.de>
 */
class Abw_ss_dsgvo_Public
{

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of the plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct($plugin_name, $version)
	{

		$this->plugin_name = $plugin_name;
		$this->version = $version;
	}

	/**
	 * Register the stylesheets for the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles()
	{

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Abw_ss_dsgvo_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Abw_ss_dsgvo_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_style('abw_ssd_styles', plugin_dir_url(__FILE__) . 'css/abw_ss_dsgvo-min.css', array(), $this->version, 'all');
	}

	/**
	 * Register the JavaScript for the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */


	public function enqueue_scripts()
	{

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Abw_ss_dsgvo_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Abw_ss_dsgvo_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		$test_mode = get_option("ssd_banner_test_mode");
		$cookie_scan_mode = isset($_GET['abw_cookie_scan']) && $_GET['abw_cookie_scan'] === '1' 
			&& get_option('ssd_cookie_scanner_debug') === '1' 
			&& current_user_can('manage_options');
		
		if (!is_user_logged_in() || $test_mode || $cookie_scan_mode) {

			wp_register_script('abw_ssd_banner', plugin_dir_url(__FILE__) . 'js/abw_ss_dsgvo-min.js', null, $this->version, true);


			require_once(plugin_dir_path(__DIR__) . 'admin/partials/default_options.php');
			$defaults = $ssd_banner_default;

			wp_localize_script(
				'abw_ssd_banner',
				'bannerConfig',
				array(
					"gaId" 					=> checkIfIdisActivated('ssd_ga_id', 'ssd_ga_active'),
					"consentMode"			=> get_option('ssd_ga_consent_mode'),
					"gtmId"					=> checkIfIdisActivated('ssd_gtm_id', 'ssd_gtm_active'),
					"hj" 					=> checkIfIdisActivated('ssd_hj_id', 'ssd_hj_active'),
					"otherScripts"			=> get_option('weitereskripte_textarea'),
					"otherBodyScripts" 		=> get_option('other_body_scripts_textarea'),
					"title" 				=> default_or_user_value('ssd_banner_title', $defaults),
					"text" 					=> default_or_user_value('ssd_banner_text', $defaults),
					"deny" 					=> default_or_user_value('ssd_deny_btn_title', $defaults),
					"consent" 				=> default_or_user_value('ssd_consent_btn_title', $defaults),
					"biased" 				=> get_option('ssd_biased_mode'),
					"footer_text_1" 		=> get_option('sdd_link_title_1'),
					"footer_url_1" 			=> get_option('ssd_link_url_1'),
					"footer_text_2" 		=> get_option('sdd_link_title_2'),
					"footer_url_2" 			=> get_option('ssd_link_url_2'),
					"titleColor" 			=> get_option('ssd_title_color'),
					"textColor" 			=> get_option('ssd_text_color'),
					"btnTextColor" 			=> get_option('ssd_btn_text_color'),
					"btnTextHoverColor" 	=> get_option('ssd_btn_text_hover_color'),
					"btnColor" 				=> get_option('ssd_btn_color'),
					"btnHoverColor" 		=> get_option('ssd_btn_hover_color'),
					"premium"				=> abw_ssd_checkIfPremium(get_option('ssd_licence_code')),
					"removeBranding" 		=> get_option('ssd_remove_branding'),
					"domain"				=> get_home_url(),
					"testMode"				=> $test_mode,
					"showKeyboardShortcuts"	=> get_option('ssd_show_keyboard_shortcuts')
				)
			);

			wp_enqueue_script('abw_ssd_banner');

			if (get_option('ssd_ga_consent_mode') && get_option('ssd_ga_active')) {
				require_once(plugin_dir_path(__DIR__) . 'public/functions/ga_consent_mode.php');
			}
		}

		if (!is_admin()) {
			include('functions/youtube.php');
			include('functions/remove_consent.php');
		}

		// Cookie-Scanner für Admins (wenn Debug aktiv)
		$cookie_scanner_debug = get_option('ssd_cookie_scanner_debug');
		if ($cookie_scanner_debug === '1' && is_user_logged_in() && current_user_can('manage_options')) {
			wp_register_script(
				'abw_ssd_cookie_scanner',
				plugin_dir_url(__FILE__) . 'js/cookie_scanner.js',
				array(),
				$this->version,
				true
			);

			wp_localize_script(
				'abw_ssd_cookie_scanner',
				'abwSsdDebug',
				array(
					'enabled' => true,
					'ajaxUrl' => admin_url('admin-ajax.php'),
					'adminUrl' => admin_url('options-general.php?page=supersimpeldsgvo#cookie-scanner-panel'),
					'nonce' => wp_create_nonce('abw_ssd_cookie_scan')
				)
			);

			wp_enqueue_script('abw_ssd_cookie_scanner');
		}
	}
}




function checkIfIdisActivated($key, $activated)
{
	if (get_option($activated) === "1") {
		return get_option($key);
	}

	return false;
}
