<?php

/**
 * Define the internationalization functionality
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @link       https://app-bis-web.de
 * @since      1.0.0
 *
 * @package    Abw_ss_dsgvo
 * @subpackage Abw_ss_dsgvo/includes
 */

/**
 * Define the internationalization functionality.
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @since      1.0.0
 * @package    Abw_ss_dsgvo
 * @subpackage Abw_ss_dsgvo/includes
 * @author     Jan Luther <info@app-bis-web.de>
 */
class Abw_ss_dsgvo_i18n {


	/**
	 * Load the plugin text domain for translation.
	 *
	 * @since    1.0.0
	 */
	public function load_plugin_textdomain() {

		load_plugin_textdomain(
			'abw_ss_dsgvo',
			false,
			dirname( dirname( plugin_basename( __FILE__ ) ) ) . '/languages/'
		);

	}



}
