<?php
// Settings Page: Super Simpel DSGVO
// Modern, beginner-friendly design

class supersimpeldsgvo_Settings_Page
{
	private $fields_config = [];

	public function __construct()
	{
		add_action('admin_menu', array($this, 'wph_create_settings'));
		add_action('admin_init', array($this, 'wph_setup_fields'));
		$this->init_fields_config();
	}

	private function init_fields_config()
	{
		$this->fields_config = array(
			// Tracking Tools
			'tracking' => array(
				'ssd_ga_active' => array(
					'label' => 'Google Analytics aktivieren',
					'type' => 'checkbox',
					'desc' => 'IP-Anonymisierung wird automatisch mit aktiviert.'
				),
				'ssd_ga_consent_mode' => array(
					'label' => 'Google Analytics Consent Mode',
					'type' => 'checkbox',
					'desc' => 'Wenn aktiv: Google Analytics läuft auch bei Ablehnung, aber mit weniger Daten (cookieless tracking).'
				),
				'ssd_ga_id' => array(
					'label' => 'Google Analytics ID',
					'type' => 'text',
					'placeholder' => 'G-XXXXXXXXXX oder UA-XXXXXXXX-X'
				),
				'ssd_gtm_active' => array(
					'label' => 'Google Tag Manager aktivieren',
					'type' => 'checkbox',
					'desc' => 'Der Tag Manager ermöglicht die Verwaltung mehrerer Tracking-Tools an einem Ort.'
				),
				'ssd_gtm_id' => array(
					'label' => 'Tag Manager Container ID',
					'type' => 'text',
					'placeholder' => 'GTM-XXXXXXX'
				),
				'ssd_hj_active' => array(
					'label' => 'Hotjar aktivieren',
					'type' => 'checkbox',
					'desc' => 'Hotjar zeigt dir, wie Besucher deine Website nutzen (Heatmaps, Aufnahmen).'
				),
				'ssd_hj_id' => array(
					'label' => 'Hotjar Site ID',
					'type' => 'text',
					'placeholder' => '1234567'
				),
			),
			// Banner Texte
			'banner_text' => array(
				'ssd_banner_title' => array(
					'label' => 'Banner Überschrift',
					'type' => 'text',
					'placeholder' => 'Cookie-Hinweis'
				),
				'ssd_banner_text' => array(
					'label' => 'Banner Text',
					'type' => 'textarea',
					'desc' => 'Erkläre kurz, warum du Cookies verwendest.'
				),
				'ssd_deny_btn_title' => array(
					'label' => 'Ablehnen-Button Text',
					'type' => 'text',
					'placeholder' => 'Nur notwendige Cookies'
				),
				'ssd_consent_btn_title' => array(
					'label' => 'Zustimmen-Button Text',
					'type' => 'text',
					'placeholder' => 'Alle Cookies zulassen'
				),
				'sdd_link_title_1' => array(
					'label' => 'Link 1 Text',
					'type' => 'text',
					'placeholder' => 'Datenschutz'
				),
				'ssd_link_url_1' => array(
					'label' => 'Link 1 URL',
					'type' => 'url',
					'placeholder' => 'https://deine-seite.de/datenschutz'
				),
				'sdd_link_title_2' => array(
					'label' => 'Link 2 Text',
					'type' => 'text',
					'placeholder' => 'Impressum'
				),
				'ssd_link_url_2' => array(
					'label' => 'Link 2 URL',
					'type' => 'url',
					'placeholder' => 'https://deine-seite.de/impressum'
				),
			),
			// Banner Design
			'banner_design' => array(
				'ssd_title_color' => array(
					'label' => 'Überschrift-Farbe',
					'type' => 'color'
				),
				'ssd_text_color' => array(
					'label' => 'Text-Farbe',
					'type' => 'color'
				),
				'ssd_btn_color' => array(
					'label' => 'Button-Farbe',
					'type' => 'color'
				),
				'ssd_btn_hover_color' => array(
					'label' => 'Button-Farbe (Hover)',
					'type' => 'color'
				),
				'ssd_btn_text_color' => array(
					'label' => 'Button-Text-Farbe',
					'type' => 'color'
				),
				'ssd_btn_text_hover_color' => array(
					'label' => 'Button-Text-Farbe (Hover)',
					'type' => 'color'
				),
				'ssd_biased_mode' => array(
					'label' => 'Zustimmen-Button hervorheben',
					'type' => 'checkbox',
					'desc' => 'Der "Zustimmen"-Button wird auffälliger gestaltet als der "Ablehnen"-Button.'
				),
				'ssd_show_keyboard_shortcuts' => array(
					'label' => 'Tastatur-Shortcuts anzeigen',
					'type' => 'checkbox',
					'desc' => 'Zeigt ESC (Ablehnen) und Enter (Zustimmen) im Banner an – gut für Barrierefreiheit.'
				),
			),
			// Videos
			'videos' => array(
				'ssd_legal_text_videos' => array(
					'label' => 'Hinweistext für Videos',
					'type' => 'textarea',
					'desc' => 'Dieser Text erscheint bei eingebetteten Videos, bevor der Nutzer zustimmt.'
				),
				'ssd_video_btn_title' => array(
					'label' => 'Video-Button Text',
					'type' => 'text',
					'placeholder' => 'Video laden'
				),
			),
			// Erweiterte Optionen
			'advanced' => array(
				'ssd_banner_test_mode' => array(
					'label' => 'Test-Modus',
					'type' => 'checkbox',
					'desc' => 'Ermöglicht das Testen des Banners, auch wenn du eingeloggt bist.'
				),
				'ssd_cookie_scanner_debug' => array(
					'label' => 'Cookie-Scanner aktivieren',
					'type' => 'checkbox',
					'desc' => 'Zeigt ein Debug-Panel im Frontend, um zu prüfen, welche Cookies gesetzt werden.'
				),
				'weitereskripte_textarea' => array(
					'label' => 'Weitere Skripte (Head)',
					'type' => 'textarea',
					'desc' => 'JavaScript-Code, der nach Zustimmung im &lt;head&gt; geladen wird.',
					'width' => '100'
				),
				'other_body_scripts_textarea' => array(
					'label' => 'Weitere Skripte (Body)',
					'type' => 'textarea',
					'desc' => 'JavaScript-Code, der nach Zustimmung im &lt;body&gt; geladen wird.',
					'width' => '100'
				),
			),
		);
	}

	public function wph_create_settings()
	{
		add_options_page(
			'Super Simpel DSGVO',
			'Super Simpel DSGVO',
			'manage_options',
			'supersimpeldsgvo',
			array($this, 'render_settings_page')
		);
	}

	public function wph_setup_fields()
	{
		// Register all fields for saving
		foreach ($this->fields_config as $section => $fields) {
			foreach ($fields as $id => $field) {
				register_setting('supersimpeldsgvo', $id);
			}
		}
	}

	private function render_field($id, $field)
	{
		require_once 'default_options.php';
		global $ssd_banner_default;

		$value = get_option($id);
		$placeholder = isset($field['placeholder']) ? $field['placeholder'] : '';
		$width = isset($field['width']) ? $field['width'] : '100';

		// Use default if empty
		if (strlen($value) < 1 && isset($ssd_banner_default[$id])) {
			$value = $ssd_banner_default[$id];
		}

		echo '<tr>';
		echo '<th scope="row"><label for="' . esc_attr($id) . '">' . esc_html($field['label']) . '</label></th>';
		echo '<td>';

		switch ($field['type']) {
			case 'checkbox':
?>
				<label style="display: inline-flex; align-items: flex-start; gap: 10px; cursor: pointer;">
					<input type="checkbox"
						id="<?php echo esc_attr($id); ?>"
						name="<?php echo esc_attr($id); ?>"
						value="1"
						<?php checked($value, '1'); ?>
						style="margin-top: 2px; flex-shrink: 0;">
					<?php if (isset($field['desc'])) : ?>
						<span class="description" style="margin: 0; color: #50575e;"><?php echo wp_kses_post($field['desc']); ?></span>
					<?php endif; ?>
				</label>
			<?php
				// Prevent double description
				unset($field['desc']);
				break;

			case 'textarea':
				printf(
					'<textarea name="%s" id="%s" placeholder="%s" rows="4" style="width: %s%%; max-width: 600px;">%s</textarea>',
					esc_attr($id),
					esc_attr($id),
					esc_attr($placeholder),
					esc_attr($width),
					esc_textarea($value)
				);
				break;

			case 'color':
				printf(
					'<input type="color" name="%s" id="%s" value="%s">',
					esc_attr($id),
					esc_attr($id),
					esc_attr($value)
				);
				break;

			case 'url':
				// Interne Seitensuche mit WordPress Link API
			?>
				<div class="ssd-page-search-wrapper" style="position: relative; max-width: 400px;">
					<input type="text"
						name="<?php echo esc_attr($id); ?>"
						id="<?php echo esc_attr($id); ?>"
						value="<?php echo esc_attr($value); ?>"
						placeholder="<?php echo esc_attr($placeholder); ?>"
						class="ssd-page-search-input"
						style="width: 100%;"
						autocomplete="off">
					<button type="button"
						class="button ssd-page-search-btn"
						data-target="<?php echo esc_attr($id); ?>"
						style="position: absolute; right: 0; top: 0; height: 100%;">
						<span class="dashicons dashicons-search" style="vertical-align: middle;"></span>
					</button>
					<div class="ssd-page-search-results"
						id="<?php echo esc_attr($id); ?>_results"
						style="display: none; position: absolute; top: 100%; left: 0; right: 0; background: white; border: 1px solid #ddd; border-top: none; max-height: 200px; overflow-y: auto; z-index: 1000; box-shadow: 0 4px 6px rgba(0,0,0,0.1);">
					</div>
				</div>
				<p class="description" style="margin-top: 5px;">
					<small>Gib einen Seitentitel ein oder füge eine vollständige URL ein.</small>
				</p>
		<?php
				break;

			default:
				printf(
					'<input type="%s" name="%s" id="%s" placeholder="%s" value="%s" style="width: 100%%; max-width: 400px;">',
					esc_attr($field['type']),
					esc_attr($id),
					esc_attr($id),
					esc_attr($placeholder),
					esc_attr($value)
				);
		}

		if (isset($field['desc'])) {
			echo '<p class="description">' . wp_kses_post($field['desc']) . '</p>';
		}

		echo '</td>';
		echo '</tr>';
	}

	public function render_settings_page()
	{
		$scanner_active = get_option('ssd_cookie_scanner_debug') === '1';
		?>
		<div class="wrap">
			<!-- Sticky Navigation -->
			<nav class="ssd-sticky-nav" id="ssd-nav">
				<div class="ssd-sticky-nav-inner">
					<a href="#section-tracking" class="ssd-nav-btn" data-section="section-tracking">
						<span class="dashicons dashicons-chart-bar ssd-nav-icon"></span> Tracking
					</a>
					<a href="#section-banner-text" class="ssd-nav-btn" data-section="section-banner-text">
						<span class="dashicons dashicons-edit ssd-nav-icon"></span> Texte
					</a>
					<a href="#section-banner-design" class="ssd-nav-btn" data-section="section-banner-design">
						<span class="dashicons dashicons-art ssd-nav-icon"></span> Design
					</a>
					<a href="#section-videos" class="ssd-nav-btn" data-section="section-videos">
						<span class="dashicons dashicons-video-alt3 ssd-nav-icon"></span> Videos
					</a>
					<a href="#section-advanced" class="ssd-nav-btn" data-section="section-advanced">
						<span class="dashicons dashicons-admin-generic ssd-nav-icon"></span> Erweitert
					</a>
					<a href="#section-shortcodes" class="ssd-nav-btn" data-section="section-shortcodes">
						<span class="dashicons dashicons-editor-code ssd-nav-icon"></span> Shortcodes
					</a>
					<a href="#cookie-scanner-panel" class="ssd-nav-btn" data-section="cookie-scanner-panel">
						<span class="dashicons dashicons-search ssd-nav-icon"></span> Scanner
					</a>

					<!-- Spacer -->
					<span style="flex-grow: 1;"></span>

					<!-- Save Button -->
					<button type="button" id="ssd-nav-save-btn" class="button button-primary">
						Änderungen speichern
					</button>
				</div>
			</nav>

			<!-- Page Header -->
			<div class="ssd-page-header">
				<h1>Super Simpel DSGVO</h1>
				<p>Mache deine Website datenschutzkonform – einfach und ohne Technik-Stress.</p>
			</div>

			<!-- Beginner Info Box -->
			<div class="ssd-info-box ssd-info-highlight">
				<h3><span class="dashicons dashicons-lightbulb"></span> Was sind eigentlich Cookies?</h3>
				<p><strong>Cookies sind kleine Textdateien</strong>, die Websites auf deinem Computer speichern. Sie merken sich z.B., ob du eingeloggt bist oder welche Produkte im Warenkorb liegen.</p>
				<p><strong>Das Problem:</strong> Manche Cookies (z.B. von Google Analytics) sammeln Daten über dein Verhalten. Laut DSGVO musst du deine Besucher vorher um Erlaubnis fragen.</p>
				<p><strong>Die Lösung:</strong> Dieses Plugin zeigt einen Cookie-Banner. Erst wenn der Besucher zustimmt, werden Tracking-Tools wie Google Analytics aktiviert.</p>
			</div>

			<!-- Warning Box -->
			<div class="ssd-info-box ssd-info-warning">
				<h3><span class="dashicons dashicons-warning"></span> Wichtig zu wissen</h3>
				<p>Damit alles funktioniert, darfst du Tracking-Skripte (Google Analytics, Facebook Pixel, etc.) <strong>nur hier</strong> einbinden – nicht über andere Plugins oder im Theme!</p>
				<?php if (get_option('ssd_cookie_scanner_debug') === '1') : ?>
					<p style="margin-top: 10px; padding-top: 10px; border-top: 1px solid rgba(245, 158, 11, 0.3);">
						<span class="dashicons dashicons-yes-alt" style="color: #059669;"></span>
						<strong>Tipp:</strong> Du hast den <a href="#cookie-scanner-panel">Cookie-Scanner</a> aktiviert. Nutze ihn, um zu prüfen, ob wirklich alle Tracking-Cookies erst nach Zustimmung gesetzt werden.
					</p>
				<?php else : ?>
					<p style="margin-top: 10px; padding-top: 10px; border-top: 1px solid rgba(245, 158, 11, 0.3);">
						<span class="dashicons dashicons-info" style="color: #8b2bd1;"></span>
						<strong>Tipp:</strong> Aktiviere den <a href="#section-advanced">Cookie-Scanner</a> unter „Erweitert", um zu prüfen, welche Cookies auf deiner Seite gesetzt werden.
					</p>
				<?php endif; ?>
			</div>

			<form method="POST" action="options.php" id="ssd-settings-form">
				<?php settings_fields('supersimpeldsgvo'); ?>

				<!-- Section: Tracking Tools -->
				<div class="ssd-section" id="section-tracking">
					<div class="ssd-section-header" onclick="toggleSection('section-tracking')">
						<h2><span class="dashicons dashicons-chart-bar" style="margin-right: 8px;"></span> Tracking-Tools einrichten</h2>
						<span class="ssd-toggle dashicons dashicons-arrow-down-alt2"></span>
					</div>
					<div class="ssd-section-content">
						<div class="ssd-info-box">
							<h3><span class="dashicons dashicons-info"></span> Was ist Tracking?</h3>
							<p>Tracking-Tools wie Google Analytics zeigen dir, wie viele Besucher deine Website hat und was sie dort machen. Das hilft dir, deine Website zu verbessern.</p>
							<p><strong>Tipp:</strong> Du brauchst nicht alle Tools! Google Analytics allein reicht für die meisten Websites.</p>
						</div>
						<table class="form-table">
							<?php
							foreach ($this->fields_config['tracking'] as $id => $field) {
								$this->render_field($id, $field);
							}
							?>
						</table>
					</div>
				</div>

				<!-- Section: Banner Text -->
				<div class="ssd-section" id="section-banner-text">
					<div class="ssd-section-header" onclick="toggleSection('section-banner-text')">
						<h2><span class="dashicons dashicons-edit" style="margin-right: 8px;"></span> Banner-Texte anpassen</h2>
						<span class="ssd-toggle dashicons dashicons-arrow-down-alt2"></span>
					</div>
					<div class="ssd-section-content">
						<div class="ssd-info-box">
							<h3><span class="dashicons dashicons-info"></span> Was steht im Banner?</h3>
							<p>Der Cookie-Banner erscheint beim ersten Besuch. Hier kannst du die Texte anpassen. Halte sie kurz und verständlich!</p>
							<p><strong>Pflicht:</strong> Verlinke deine Datenschutzerklärung und dein Impressum im Banner.</p>
						</div>
						<table class="form-table">
							<?php
							foreach ($this->fields_config['banner_text'] as $id => $field) {
								$this->render_field($id, $field);
							}
							?>
						</table>
					</div>
				</div>

				<!-- Section: Banner Design -->
				<div class="ssd-section" id="section-banner-design">
					<div class="ssd-section-header" onclick="toggleSection('section-banner-design')">
						<h2><span class="dashicons dashicons-art" style="margin-right: 8px;"></span> Banner-Design</h2>
						<span class="ssd-toggle dashicons dashicons-arrow-down-alt2"></span>
					</div>
					<div class="ssd-section-content">
						<div class="ssd-info-box">
							<h3><span class="dashicons dashicons-info"></span> Farben & Stil</h3>
							<p>Passe die Farben an dein Website-Design an. Klicke auf die Farbfelder, um einen Farbwähler zu öffnen.</p>
						</div>
						<table class="form-table">
							<?php
							foreach ($this->fields_config['banner_design'] as $id => $field) {
								$this->render_field($id, $field);
							}
							?>
						</table>
					</div>
				</div>

				<!-- Section: Videos -->
				<div class="ssd-section" id="section-videos">
					<div class="ssd-section-header" onclick="toggleSection('section-videos')">
						<h2><span class="dashicons dashicons-video-alt3" style="margin-right: 8px;"></span> YouTube-Videos</h2>
						<span class="ssd-toggle dashicons dashicons-arrow-down-alt2"></span>
					</div>
					<div class="ssd-section-content">
						<div class="ssd-info-box">
							<h3><span class="dashicons dashicons-info"></span> Warum Videos extra?</h3>
							<p>YouTube-Videos setzen automatisch Cookies, wenn sie geladen werden. Mit diesem Plugin wird erst ein Vorschaubild angezeigt. Das Video lädt erst, wenn der Besucher aktiv klickt.</p>
							<p><strong>Bonus:</strong> Das macht deine Website auch schneller!</p>
						</div>
						<table class="form-table">
							<?php
							foreach ($this->fields_config['videos'] as $id => $field) {
								$this->render_field($id, $field);
							}
							?>
						</table>

						<hr style="margin: 30px 0;">

						<h3>So bindest du Videos ein</h3>
						<p>Verwende diesen Shortcode in deinen Seiten oder Beiträgen:</p>

						<div class="ssd-shortcode-box">[abw_yt id="VIDEO_ID"]</div>

						<p><strong>Beispiel:</strong> Bei der YouTube-URL <code>https://www.youtube.com/watch?v=dQw4w9WgXcQ</code> ist die Video-ID <code>dQw4w9WgXcQ</code>.</p>

						<details style="margin-top: 20px;">
							<summary style="cursor: pointer; font-weight: 600; color: var(--ssd-primary);">Weitere Optionen anzeigen</summary>
							<div style="padding: 15px 0;">
								<p><strong>Hochformat (z.B. TikTok/Instagram):</strong></p>
								<div class="ssd-shortcode-box">[abw_yt id="VIDEO_ID" hochformat]</div>

								<p><strong>Eigene Größe festlegen:</strong></p>
								<div class="ssd-shortcode-box">[abw_yt id="VIDEO_ID" w="315" h="560"]</div>
							</div>
						</details>
					</div>
				</div>

				<!-- Section: Advanced -->
				<div class="ssd-section" id="section-advanced">
					<div class="ssd-section-header" onclick="toggleSection('section-advanced')">
						<h2><span class="dashicons dashicons-admin-generic" style="margin-right: 8px;"></span> Erweiterte Optionen</h2>
						<span class="ssd-toggle dashicons dashicons-arrow-down-alt2"></span>
					</div>
					<div class="ssd-section-content">
						<div class="ssd-info-box ssd-info-warning">
							<h3><span class="dashicons dashicons-warning"></span> Für Fortgeschrittene</h3>
							<p>Diese Optionen sind für technisch versierte Nutzer. Wenn du dir unsicher bist, lass sie einfach aus.</p>
						</div>
						<table class="form-table">
							<?php
							foreach ($this->fields_config['advanced'] as $id => $field) {
								$this->render_field($id, $field);
							}
							?>
						</table>

						<?php if (get_option('ssd_banner_test_mode') === '1') : ?>
							<div class="ssd-info-box ssd-info-success" style="margin-top: 20px;">
								<p><strong>Test-Modus aktiviert</strong> – Du kannst das Banner jetzt als eingeloggter Admin sehen:</p>
								<a href="<?php echo esc_url(get_home_url()); ?>" target="_blank" class="button" style="margin-top: 8px;">
									Zur Website →
								</a>
							</div>
						<?php endif; ?>
					</div>
				</div>

				<!-- Submit Button -->
				<div style="margin-top: 30px;">
					<?php submit_button('Einstellungen speichern', 'primary ssd-btn-primary', 'submit', false); ?>
				</div>
			</form>

			<!-- Shortcode Info -->
			<div class="ssd-section" id="section-shortcodes" style="margin-top: 30px;">
				<div class="ssd-section-header" onclick="toggleSection('section-shortcodes')">
					<h2><span class="dashicons dashicons-editor-code" style="margin-right: 8px;"></span> Widerrufs-Link einbinden</h2>
					<span class="ssd-toggle dashicons dashicons-arrow-down-alt2"></span>
				</div>
				<div class="ssd-section-content">
					<p>Laut DSGVO müssen Besucher ihre Cookie-Einwilligung jederzeit widerrufen können. Füge diesen Shortcode auf deiner Datenschutz-Seite ein:</p>
					<div class="ssd-shortcode-box">[abw_consent]</div>
					<p class="description">Dieser Link erscheint nur für nicht eingeloggte Besucher.</p>
				</div>
			</div>

			<!-- Cookie Scanner Panel -->
			<?php $this->render_cookie_scanner_panel(); ?>

			<!-- Disclaimer Section -->
			<div class="ssd-section" id="section-disclaimer" style="margin-top: 30px; border-color: var(--ssd-gray-300);">
				<div class="ssd-section-header" style="background: var(--ssd-gray-100);" onclick="toggleSection('section-disclaimer')">
					<h2 style="color: var(--ssd-gray-700);"><span class="dashicons dashicons-shield" style="margin-right: 8px;"></span> Wichtige Hinweise & Haftungsausschluss</h2>
					<span class="ssd-toggle dashicons dashicons-arrow-down-alt2"></span>
				</div>
				<div class="ssd-section-content" style="font-size: 13px; line-height: 1.7; color: var(--ssd-gray-700);">

					<h3 style="margin-top: 0;">1. Zweck und Grenzen dieses Plugins</h3>
					<p>Dieses Plugin unterstützt dich dabei, deine WordPress-Website datenschutzfreundlicher zu gestalten. Es bietet:</p>
					<ul>
						<li>Einen Cookie-Banner zur Einholung der Nutzereinwilligung</li>
						<li>Die verzögerte Einbindung von Tracking-Skripten (erst nach Zustimmung)</li>
						<li>Datenschutzfreundliche YouTube-Einbettung</li>
						<li>Einen Cookie-Scanner zur Überprüfung</li>
					</ul>

					<div style="background: #fef3c7; border-left: 4px solid #f59e0b; padding: 15px; margin: 20px 0; border-radius: 0 8px 8px 0;">
						<strong>⚠️ Wichtig:</strong> Dieses Plugin ersetzt <strong>keine rechtliche Beratung</strong>. Die DSGVO und das TTDSG stellen komplexe rechtliche Anforderungen, die je nach Einzelfall unterschiedlich auszulegen sind. Für eine rechtssichere Umsetzung solltest du einen Rechtsanwalt oder Datenschutzbeauftragten konsultieren.
					</div>

					<h3>2. Bekannte Einschränkungen</h3>
					<p>Bitte beachte folgende technische Einschränkungen:</p>
					<ul>
						<li><strong>Keine Garantie für vollständige Cookie-Blockierung:</strong> Andere Plugins, Themes oder externe Skripte können unabhängig von diesem Plugin Cookies setzen.</li>
						<li><strong>HttpOnly- und Drittanbieter-Cookies:</strong> Der Cookie-Scanner kann nur Cookies erkennen, die über JavaScript auslesbar sind. HttpOnly-Cookies und Cookies von Drittanbieter-Domains werden nicht erfasst.</li>
						<li><strong>Serverseitige Cookies:</strong> Cookies, die serverseitig gesetzt werden (z.B. PHP-Sessions), werden vor der Einwilligung möglicherweise trotzdem gesetzt.</li>
						<li><strong>Cache-Plugins:</strong> Bei Verwendung von Caching-Plugins kann es zu verzögerter Aktualisierung des Banners kommen.</li>
						<li><strong>Cookie-Datenbank:</strong> Die Liste bekannter Cookies ist nicht vollständig und kann veraltete Informationen enthalten.</li>
					</ul>

					<h3>3. Mögliche Fehlkonfigurationen</h3>
					<p>Die korrekte Funktion des Plugins hängt von der richtigen Konfiguration ab. Häufige Fehlerquellen:</p>
					<ul>
						<li><strong>Tracking-Skripte an anderer Stelle eingebunden:</strong> Wenn du Google Analytics, Facebook Pixel oder ähnliche Tools über andere Plugins oder direkt im Theme einbindest, werden diese nicht durch dieses Plugin blockiert.</li>
						<li><strong>Fehlende oder falsche IDs:</strong> Bei falschen Tracking-IDs werden die entsprechenden Dienste nicht korrekt geladen.</li>
						<li><strong>Unvollständige Datenschutzerklärung:</strong> Der Cookie-Banner allein erfüllt nicht die DSGVO-Anforderungen – du benötigst zusätzlich eine vollständige Datenschutzerklärung.</li>
						<li><strong>Fehlende Widerrufsmöglichkeit:</strong> Vergiss nicht, den Shortcode <code>[abw_consent]</code> auf deiner Datenschutzseite einzubinden.</li>
					</ul>

					<h3>4. Haftungsausschluss</h3>
					<div style="background: var(--ssd-gray-50); border: 1px solid var(--ssd-gray-200); padding: 20px; border-radius: 8px; margin: 15px 0;">
						<p style="margin-top: 0;"><strong>Gewährleistung:</strong> Dieses Plugin wird „wie besehen" („as is") ohne jegliche ausdrückliche oder stillschweigende Gewährleistung zur Verfügung gestellt. Der Entwickler übernimmt keine Garantie für die Eignung des Plugins für einen bestimmten Zweck, insbesondere nicht für die vollständige Einhaltung der DSGVO, des TTDSG oder anderer Datenschutzvorschriften.</p>

						<p><strong>Haftungsbeschränkung:</strong> Soweit gesetzlich zulässig, haftet der Entwickler nicht für Schäden, die aus der Nutzung oder der Unmöglichkeit der Nutzung dieses Plugins entstehen, einschließlich, aber nicht beschränkt auf:</p>
						<ul style="margin-bottom: 15px;">
							<li>Bußgelder oder Abmahnungen wegen Datenschutzverstößen</li>
							<li>Direkte, indirekte, zufällige oder Folgeschäden</li>
							<li>Datenverlust oder Geschäftsunterbrechungen</li>
						</ul>

						<p><strong>Ausnahmen:</strong> Die vorstehende Haftungsbeschränkung gilt nicht für:</p>
						<ul style="margin-bottom: 15px;">
							<li>Vorsätzliches oder grob fahrlässiges Verhalten des Entwicklers</li>
							<li>Schäden aus der Verletzung von Leben, Körper oder Gesundheit</li>
							<li>Ansprüche nach dem Produkthaftungsgesetz</li>
							<li>Sonstige Fälle zwingender gesetzlicher Haftung</li>
						</ul>

						<p style="margin-bottom: 0;"><strong>Eigenverantwortung:</strong> Du bist als Website-Betreiber selbst dafür verantwortlich, die Einhaltung der für dich geltenden Datenschutzvorschriften sicherzustellen. Dies umfasst die regelmäßige Überprüfung der Plugin-Konfiguration, das Testen der Cookie-Funktionalität und die Aktualisierung bei Änderungen der Rechtslage.</p>
					</div>

					<h3>5. Empfehlungen</h3>
					<ul>
						<li>✓ Nutze den Cookie-Scanner regelmäßig, um zu prüfen, welche Cookies gesetzt werden</li>
						<li>✓ Teste deine Website im privaten/Inkognito-Modus nach dem Leeren aller Cookies</li>
						<li>✓ Halte das Plugin und WordPress aktuell</li>
						<li>✓ Dokumentiere deine Datenschutzmaßnahmen</li>
						<li>✓ Konsultiere bei Unsicherheiten einen Datenschutz-Experten</li>
					</ul>

					<p style="margin-top: 20px; padding-top: 15px; border-top: 1px solid var(--ssd-gray-200); color: var(--ssd-gray-500); font-size: 12px;">
						<strong>Entwickler:</strong> Jan Luther / App bis Web ·
						<a href="https://app-bis-web.de" target="_blank" rel="noopener">app-bis-web.de</a> ·

					</p>
				</div>
			</div>

			<!-- Toggle Script & Navigation Highlighting -->
			<script>
				(function() {
					// Section Toggle
					window.toggleSection = function(sectionId) {
						var section = document.getElementById(sectionId);
						if (section) {
							section.classList.toggle('collapsed');
						}
					};

					// Smooth Scroll & Active Navigation
					var navBtns = document.querySelectorAll('.ssd-nav-btn');
					var sections = [];

					navBtns.forEach(function(btn) {
						var sectionId = btn.getAttribute('data-section');
						var section = document.getElementById(sectionId);
						if (section) {
							sections.push({
								id: sectionId,
								el: section,
								btn: btn
							});
						}

						// Smooth scroll on click
						btn.addEventListener('click', function(e) {
							e.preventDefault();
							var target = document.getElementById(sectionId);
							if (target) {
								// Expand section if collapsed
								if (target.classList.contains('collapsed')) {
									target.classList.remove('collapsed');
								}
								// Scroll with offset for sticky nav
								var offset = 100;
								var top = target.getBoundingClientRect().top + window.pageYOffset - offset;
								window.scrollTo({
									top: top,
									behavior: 'smooth'
								});
							}
						});
					});

					// Highlight current section on scroll
					function updateActiveNav() {
						var scrollPos = window.pageYOffset + 150;
						var currentSection = null;

						sections.forEach(function(s) {
							if (s.el.offsetTop <= scrollPos) {
								currentSection = s;
							}
						});

						navBtns.forEach(function(btn) {
							btn.classList.remove('active');
						});

						if (currentSection) {
							currentSection.btn.classList.add('active');
						}
					}

					window.addEventListener('scroll', updateActiveNav);
					updateActiveNav(); // Initial call

					// ========================================
					// Save Button in Navigation
					// ========================================
					var saveBtn = document.getElementById('ssd-nav-save-btn');
					var settingsForm = document.getElementById('ssd-settings-form');

					if (saveBtn && settingsForm) {
						saveBtn.addEventListener('click', function(e) {
							e.preventDefault();
							// Visual feedback
							this.textContent = 'Speichern...';
							this.disabled = true;
							// Submit form using prototype (workaround for name="submit" conflict)
							HTMLFormElement.prototype.submit.call(settingsForm);
						});
					}

					// ========================================
					// Page Search (WordPress wp-link-ajax API)
					// ========================================
					var searchTimeout = null;
					var activeResults = null;

					// Initialize page search buttons
					document.querySelectorAll('.ssd-page-search-btn').forEach(function(btn) {
						btn.addEventListener('click', function() {
							var targetId = this.getAttribute('data-target');
							var input = document.getElementById(targetId);
							if (input && input.value.length >= 2) {
								searchPages(input.value, targetId);
							} else if (input) {
								// Show all pages if input is empty/short
								searchPages('', targetId);
							}
						});
					});

					// Initialize page search inputs
					document.querySelectorAll('.ssd-page-search-input').forEach(function(input) {
						// Search on typing
						input.addEventListener('input', function() {
							var targetId = this.id;
							var query = this.value;

							clearTimeout(searchTimeout);

							// Only search if it looks like a search term (not a URL)
							if (query.indexOf('http') === 0 || query.indexOf('/') === 0) {
								hideResults(targetId);
								return;
							}

							if (query.length >= 2) {
								searchTimeout = setTimeout(function() {
									searchPages(query, targetId);
								}, 300);
							} else {
								hideResults(targetId);
							}
						});

						// Hide results when clicking outside
						document.addEventListener('click', function(e) {
							if (!e.target.closest('.ssd-page-search-wrapper')) {
								document.querySelectorAll('.ssd-page-search-results').forEach(function(el) {
									el.style.display = 'none';
								});
							}
						});
					});

					function searchPages(query, targetId) {
						var resultsEl = document.getElementById(targetId + '_results');
						if (!resultsEl) return;

						resultsEl.innerHTML = '<div style="padding: 10px; color: #666;">Suche...</div>';
						resultsEl.style.display = 'block';

						// Use WordPress wp-link-ajax API
						var formData = new FormData();
						formData.append('action', 'wp-link-ajax');
						formData.append('_ajax_linking_nonce', '<?php echo wp_create_nonce('internal-linking'); ?>');
						formData.append('search', query);
						formData.append('page', 1);

						fetch(ajaxurl, {
								method: 'POST',
								body: formData
							})
							.then(function(response) {
								return response.json();
							})
							.then(function(data) {
								if (data && data.length > 0) {
									var html = '';
									data.forEach(function(item) {
										html += '<div class="ssd-page-result" data-url="' + item.permalink + '" style="padding: 8px 12px; cursor: pointer; border-bottom: 1px solid #eee;">';
										html += '<strong style="display: block; font-size: 13px;">' + item.title + '</strong>';
										html += '<small style="color: #666;">' + item.info + '</small>';
										html += '</div>';
									});
									resultsEl.innerHTML = html;

									// Add click handlers
									resultsEl.querySelectorAll('.ssd-page-result').forEach(function(result) {
										result.addEventListener('click', function() {
											var url = this.getAttribute('data-url');
											document.getElementById(targetId).value = url;
											resultsEl.style.display = 'none';
										});
										result.addEventListener('mouseenter', function() {
											this.style.background = '#f0f0f1';
										});
										result.addEventListener('mouseleave', function() {
											this.style.background = 'white';
										});
									});
								} else {
									resultsEl.innerHTML = '<div style="padding: 10px; color: #666;">Keine Seiten gefunden. Du kannst auch eine URL direkt eingeben.</div>';
								}
							})
							.catch(function() {
								resultsEl.innerHTML = '<div style="padding: 10px; color: #999;">Fehler bei der Suche.</div>';
							});
					}

					function hideResults(targetId) {
						var resultsEl = document.getElementById(targetId + '_results');
						if (resultsEl) {
							resultsEl.style.display = 'none';
						}
					}
				})();
			</script>
		</div>
	<?php
	}

	/**
	 * Bekannte Cookies mit Beschreibungen und Sicherheitsstatus
	 * Quellen: https://developer.wordpress.org/advanced-administration/wordpress/cookies/
	 */
	private function get_known_cookies()
	{
		return array(
			// ============================================
			// DIESES PLUGIN
			// ============================================
			'appbisweb-cookieconsent' => array(
				'safe' => true,
				'category' => 'Notwendig',
				'desc' => 'Speichert die Cookie-Einwilligung (Super Simpel DSGVO).',
				'duration' => '90 Tage'
			),

			// ============================================
			// WORDPRESS CORE (lt. offizieller Dokumentation)
			// ============================================
			'wordpress_' => array(
				'safe' => true,
				'category' => 'WordPress',
				'desc' => 'Authentifizierung für den Admin-Bereich (/wp-admin/).',
				'prefix' => true,
				'duration' => 'Session oder 14 Tage'
			),
			'wordpress_logged_in_' => array(
				'safe' => true,
				'category' => 'WordPress',
				'desc' => 'Zeigt an, ob und wer eingeloggt ist.',
				'prefix' => true,
				'duration' => 'Session oder 14 Tage'
			),
			'wordpress_sec_' => array(
				'safe' => true,
				'category' => 'WordPress',
				'desc' => 'Sicherheits-Cookie für den Admin-Bereich.',
				'prefix' => true,
				'duration' => 'Session'
			),
			'wp-settings-' => array(
				'safe' => true,
				'category' => 'WordPress',
				'desc' => 'Speichert Benutzereinstellungen im Admin.',
				'prefix' => true,
				'duration' => '1 Jahr'
			),
			'wp-settings-time-' => array(
				'safe' => true,
				'category' => 'WordPress',
				'desc' => 'Zeitstempel für Benutzereinstellungen.',
				'prefix' => true,
				'duration' => '1 Jahr'
			),
			'wp_lang' => array(
				'safe' => true,
				'category' => 'WordPress',
				'desc' => 'Speichert die gewählte Sprache.',
				'duration' => 'Session'
			),
			'wordpress_test_cookie' => array(
				'safe' => true,
				'category' => 'WordPress',
				'desc' => 'Prüft, ob Cookies aktiviert sind.',
				'duration' => 'Session'
			),
			'comment_author_' => array(
				'safe' => true,
				'category' => 'WordPress',
				'desc' => 'Speichert den Kommentator-Namen.',
				'prefix' => true,
				'duration' => '1 Jahr'
			),
			'comment_author_email_' => array(
				'safe' => true,
				'category' => 'WordPress',
				'desc' => 'Speichert die Kommentator-E-Mail.',
				'prefix' => true,
				'duration' => '1 Jahr'
			),
			'comment_author_url_' => array(
				'safe' => true,
				'category' => 'WordPress',
				'desc' => 'Speichert die Kommentator-Website.',
				'prefix' => true,
				'duration' => '1 Jahr'
			),

			// ============================================
			// WOOCOMMERCE
			// ============================================
			'woocommerce_cart_hash' => array(
				'safe' => true,
				'category' => 'WooCommerce',
				'desc' => 'Hilft WooCommerce zu erkennen, wann sich der Warenkorb ändert.',
				'duration' => 'Session'
			),
			'woocommerce_items_in_cart' => array(
				'safe' => true,
				'category' => 'WooCommerce',
				'desc' => 'Hilft WooCommerce zu erkennen, wann sich der Warenkorb ändert.',
				'duration' => 'Session'
			),
			'wp_woocommerce_session_' => array(
				'safe' => true,
				'category' => 'WooCommerce',
				'desc' => 'Enthält einen eindeutigen Code für jeden Kunden (Warenkorb-Daten).',
				'prefix' => true,
				'duration' => '2 Tage'
			),
			'woocommerce_recently_viewed' => array(
				'safe' => true,
				'category' => 'WooCommerce',
				'desc' => 'Speichert kürzlich angesehene Produkte.',
				'duration' => 'Session'
			),
			'store_notice' => array(
				'safe' => true,
				'category' => 'WooCommerce',
				'desc' => 'Speichert, ob der Shop-Hinweis geschlossen wurde.',
				'duration' => 'Session'
			),
			'wc_cart_hash_' => array(
				'safe' => true,
				'category' => 'WooCommerce',
				'desc' => 'WooCommerce Warenkorb-Hash.',
				'prefix' => true,
				'duration' => 'Session'
			),

			// ============================================
			// WPML (Mehrsprachigkeit)
			// ============================================
			'wp-wpml_current_language' => array(
				'safe' => true,
				'category' => 'WPML',
				'desc' => 'Speichert die aktuell gewählte Sprache.',
				'duration' => '1 Tag'
			),
			'_icl_current_language' => array(
				'safe' => true,
				'category' => 'WPML',
				'desc' => 'WPML Spracheinstellung.',
				'duration' => '1 Tag'
			),
			'wpml_browser_redirect_test' => array(
				'safe' => true,
				'category' => 'WPML',
				'desc' => 'WPML Browser-Weiterleitung Test.',
				'duration' => 'Session'
			),

			// ============================================
			// POLYLANG (Mehrsprachigkeit)
			// ============================================
			'pll_language' => array(
				'safe' => true,
				'category' => 'Polylang',
				'desc' => 'Speichert die gewählte Sprache.',
				'duration' => '1 Jahr'
			),

			// ============================================
			// WORDFENCE (Sicherheit)
			// ============================================
			'wfvt_' => array(
				'safe' => true,
				'category' => 'Wordfence',
				'desc' => 'Wordfence Sicherheits-Token.',
				'prefix' => true,
				'duration' => '30 Min'
			),
			'wordfence_verifiedHuman' => array(
				'safe' => true,
				'category' => 'Wordfence',
				'desc' => 'Verifiziert, dass der Besucher ein Mensch ist.',
				'duration' => '1 Tag'
			),

			// ============================================
			// CLOUDFLARE
			// ============================================
			'__cf_bm' => array(
				'safe' => true,
				'category' => 'Cloudflare',
				'desc' => 'Cloudflare Bot-Management.',
				'duration' => '30 Min'
			),
			'__cfruid' => array(
				'safe' => true,
				'category' => 'Cloudflare',
				'desc' => 'Cloudflare Rate-Limiting.',
				'duration' => 'Session'
			),
			'cf_clearance' => array(
				'safe' => true,
				'category' => 'Cloudflare',
				'desc' => 'Cloudflare Challenge bestanden.',
				'duration' => '1 Jahr'
			),

			// ============================================
			// COOKIE-CONSENT PLUGINS (andere)
			// ============================================
			'cookielawinfo-' => array(
				'safe' => true,
				'category' => 'Cookie-Plugin',
				'desc' => 'Cookie-Einwilligung (GDPR Cookie Consent).',
				'prefix' => true,
				'duration' => '1 Jahr'
			),
			'CookieLawInfoConsent' => array(
				'safe' => true,
				'category' => 'Cookie-Plugin',
				'desc' => 'Cookie-Einwilligung (GDPR Cookie Consent).',
				'duration' => '1 Jahr'
			),
			'viewed_cookie_policy' => array(
				'safe' => true,
				'category' => 'Cookie-Plugin',
				'desc' => 'Cookie-Banner wurde angezeigt.',
				'duration' => '1 Jahr'
			),
			'cmplz_' => array(
				'safe' => true,
				'category' => 'Cookie-Plugin',
				'desc' => 'Complianz Cookie-Einwilligung.',
				'prefix' => true,
				'duration' => '1 Jahr'
			),
			'moove_gdpr_popup' => array(
				'safe' => true,
				'category' => 'Cookie-Plugin',
				'desc' => 'GDPR Cookie Compliance.',
				'duration' => '1 Jahr'
			),

			// ============================================
			// ELEMENTOR
			// ============================================
			'elementor' => array(
				'safe' => true,
				'category' => 'Elementor',
				'desc' => 'Elementor Editor-Einstellungen.',
				'duration' => 'Session'
			),

			// ============================================
			// JETPACK
			// ============================================
			'tk_' => array(
				'safe' => false,
				'category' => 'Jetpack',
				'desc' => 'Jetpack/WordPress.com Tracking.',
				'prefix' => true,
				'tracking' => true,
				'duration' => '5 Jahre'
			),
			'jetpack' => array(
				'safe' => true,
				'category' => 'Jetpack',
				'desc' => 'Jetpack Funktionalität.',
				'prefix' => true,
				'duration' => 'Session'
			),

			// ============================================
			// GOOGLE ANALYTICS
			// ============================================
			'_ga' => array(
				'safe' => false,
				'category' => 'Google Analytics',
				'desc' => 'Unterscheidet Besucher.',
				'tracking' => true,
				'duration' => '2 Jahre'
			),
			'_ga_' => array(
				'safe' => false,
				'category' => 'Google Analytics',
				'desc' => 'GA4 – Speichert Session-Status.',
				'prefix' => true,
				'tracking' => true,
				'duration' => '2 Jahre'
			),
			'_gid' => array(
				'safe' => false,
				'category' => 'Google Analytics',
				'desc' => 'Unterscheidet Besucher (24h).',
				'tracking' => true,
				'duration' => '24 Stunden'
			),
			'_gat' => array(
				'safe' => false,
				'category' => 'Google Analytics',
				'desc' => 'Begrenzt Anfragerate.',
				'tracking' => true,
				'duration' => '1 Minute'
			),
			'_gac_' => array(
				'safe' => false,
				'category' => 'Google Ads',
				'desc' => 'Google Ads Conversion-Tracking.',
				'prefix' => true,
				'tracking' => true,
				'duration' => '90 Tage'
			),
			'_gcl_' => array(
				'safe' => false,
				'category' => 'Google Ads',
				'desc' => 'Google Click ID für Conversion.',
				'prefix' => true,
				'tracking' => true,
				'duration' => '90 Tage'
			),

			// ============================================
			// GOOGLE TAG MANAGER
			// ============================================
			'_dc_gtm_' => array(
				'safe' => false,
				'category' => 'GTM',
				'desc' => 'Google Tag Manager Tracking.',
				'prefix' => true,
				'tracking' => true,
				'duration' => '1 Minute'
			),

			// ============================================
			// HOTJAR
			// ============================================
			'_hj' => array(
				'safe' => false,
				'category' => 'Hotjar',
				'desc' => 'Hotjar – Analyse des Nutzerverhaltens.',
				'prefix' => true,
				'tracking' => true,
				'duration' => '1 Jahr'
			),
			'_hjSession' => array(
				'safe' => false,
				'category' => 'Hotjar',
				'desc' => 'Hotjar Session-Daten.',
				'prefix' => true,
				'tracking' => true,
				'duration' => '30 Min'
			),
			'_hjid' => array(
				'safe' => false,
				'category' => 'Hotjar',
				'desc' => 'Hotjar Besucher-ID.',
				'tracking' => true,
				'duration' => '1 Jahr'
			),

			// ============================================
			// FACEBOOK / META
			// ============================================
			'_fbp' => array(
				'safe' => false,
				'category' => 'Facebook',
				'desc' => 'Facebook Pixel – Tracking für Werbung.',
				'tracking' => true,
				'duration' => '3 Monate'
			),
			'_fbc' => array(
				'safe' => false,
				'category' => 'Facebook',
				'desc' => 'Facebook Click ID.',
				'tracking' => true,
				'duration' => '3 Monate'
			),
			'fr' => array(
				'safe' => false,
				'category' => 'Facebook',
				'desc' => 'Facebook Werbe-Cookie.',
				'tracking' => true,
				'duration' => '3 Monate'
			),

			// ============================================
			// LINKEDIN
			// ============================================
			'li_' => array(
				'safe' => false,
				'category' => 'LinkedIn',
				'desc' => 'LinkedIn Tracking/Werbung.',
				'prefix' => true,
				'tracking' => true,
				'duration' => '1-2 Jahre'
			),
			'lidc' => array(
				'safe' => false,
				'category' => 'LinkedIn',
				'desc' => 'LinkedIn Routing.',
				'tracking' => true,
				'duration' => '1 Tag'
			),
			'bcookie' => array(
				'safe' => false,
				'category' => 'LinkedIn',
				'desc' => 'LinkedIn Browser ID.',
				'tracking' => true,
				'duration' => '2 Jahre'
			),

			// ============================================
			// TWITTER / X
			// ============================================
			'guest_id' => array(
				'safe' => false,
				'category' => 'Twitter/X',
				'desc' => 'Twitter Gast-ID.',
				'tracking' => true,
				'duration' => '2 Jahre'
			),
			'personalization_id' => array(
				'safe' => false,
				'category' => 'Twitter/X',
				'desc' => 'Twitter Personalisierung.',
				'tracking' => true,
				'duration' => '2 Jahre'
			),

			// ============================================
			// PINTEREST
			// ============================================
			'_pinterest_' => array(
				'safe' => false,
				'category' => 'Pinterest',
				'desc' => 'Pinterest Tracking.',
				'prefix' => true,
				'tracking' => true,
				'duration' => '1 Jahr'
			),
			'_pin_unauth' => array(
				'safe' => false,
				'category' => 'Pinterest',
				'desc' => 'Pinterest Tracking.',
				'tracking' => true,
				'duration' => '1 Jahr'
			),

			// ============================================
			// TIKTOK
			// ============================================
			'_ttp' => array(
				'safe' => false,
				'category' => 'TikTok',
				'desc' => 'TikTok Pixel Tracking.',
				'tracking' => true,
				'duration' => '13 Monate'
			),
			'_tt_' => array(
				'safe' => false,
				'category' => 'TikTok',
				'desc' => 'TikTok Tracking.',
				'prefix' => true,
				'tracking' => true,
				'duration' => '13 Monate'
			),

			// ============================================
			// MATOMO / PIWIK (Self-hosted Analytics)
			// ============================================
			'_pk_' => array(
				'safe' => false,
				'category' => 'Matomo',
				'desc' => 'Matomo/Piwik Analytics.',
				'prefix' => true,
				'tracking' => true,
				'duration' => '13 Monate'
			),
			'mtm_' => array(
				'safe' => false,
				'category' => 'Matomo',
				'desc' => 'Matomo Tag Manager.',
				'prefix' => true,
				'tracking' => true,
				'duration' => '6 Monate'
			),

			// ============================================
			// MAILCHIMP
			// ============================================
			'mailchimp' => array(
				'safe' => false,
				'category' => 'Mailchimp',
				'desc' => 'Mailchimp Marketing.',
				'prefix' => true,
				'tracking' => true,
				'duration' => '30 Tage'
			),

			// ============================================
			// YOUTUBE (Embedded Videos)
			// ============================================
			'YSC' => array(
				'safe' => false,
				'category' => 'YouTube',
				'desc' => 'YouTube Session-Cookie.',
				'tracking' => true,
				'duration' => 'Session'
			),
			'VISITOR_INFO1_LIVE' => array(
				'safe' => false,
				'category' => 'YouTube',
				'desc' => 'YouTube Tracking.',
				'tracking' => true,
				'duration' => '6 Monate'
			),
			'GPS' => array(
				'safe' => false,
				'category' => 'YouTube',
				'desc' => 'YouTube GPS-Standort.',
				'tracking' => true,
				'duration' => '30 Min'
			),
			'PREF' => array(
				'safe' => false,
				'category' => 'YouTube/Google',
				'desc' => 'Google/YouTube Einstellungen.',
				'tracking' => true,
				'duration' => '2 Jahre'
			),

			// ============================================
			// VIMEO
			// ============================================
			'vuid' => array(
				'safe' => false,
				'category' => 'Vimeo',
				'desc' => 'Vimeo Analytics.',
				'tracking' => true,
				'duration' => '2 Jahre'
			),
			'player' => array(
				'safe' => true,
				'category' => 'Vimeo',
				'desc' => 'Vimeo Player-Einstellungen.',
				'duration' => '1 Jahr'
			),

			// ============================================
			// HUBSPOT
			// ============================================
			'__hs' => array(
				'safe' => false,
				'category' => 'HubSpot',
				'desc' => 'HubSpot Tracking.',
				'prefix' => true,
				'tracking' => true,
				'duration' => '13 Monate'
			),
			'hubspotutk' => array(
				'safe' => false,
				'category' => 'HubSpot',
				'desc' => 'HubSpot Besucher-Tracking.',
				'tracking' => true,
				'duration' => '13 Monate'
			),

			// ============================================
			// INTERCOM
			// ============================================
			'intercom-' => array(
				'safe' => false,
				'category' => 'Intercom',
				'desc' => 'Intercom Chat/Support.',
				'prefix' => true,
				'tracking' => true,
				'duration' => '9 Monate'
			),

			// ============================================
			// CRISP
			// ============================================
			'crisp-client' => array(
				'safe' => true,
				'category' => 'Crisp',
				'desc' => 'Crisp Chat Client-ID.',
				'prefix' => true,
				'duration' => '6 Monate'
			),

			// ============================================
			// STRIPE
			// ============================================
			'__stripe_' => array(
				'safe' => true,
				'category' => 'Stripe',
				'desc' => 'Stripe Zahlungs-Sicherheit.',
				'prefix' => true,
				'duration' => '1 Jahr'
			),

			// ============================================
			// PAYPAL
			// ============================================
			'PYPF' => array(
				'safe' => true,
				'category' => 'PayPal',
				'desc' => 'PayPal Zahlungs-Funktionalität.',
				'duration' => 'Session'
			),
		);
	}

	/**
	 * Findet Cookie-Info anhand des Namens
	 */
	private function get_cookie_info($cookie_name)
	{
		$known = $this->get_known_cookies();

		// Exakter Match
		if (isset($known[$cookie_name])) {
			return $known[$cookie_name];
		}

		// Prefix-Match (für Cookies wie wordpress_logged_in_abc123)
		foreach ($known as $key => $info) {
			if (isset($info['prefix']) && $info['prefix'] && strpos($cookie_name, $key) === 0) {
				return $info;
			}
		}

		// Unbekannter Cookie
		return array(
			'safe' => null,
			'category' => 'Unbekannt',
			'desc' => 'Dieser Cookie ist nicht in unserer Datenbank.'
		);
	}

	private function render_cookie_scanner_panel()
	{
		$scanner_active = get_option('ssd_cookie_scanner_debug') === '1';
	?>
		<div class="ssd-section" id="cookie-scanner-panel" style="margin-top: 30px; <?php echo $scanner_active ? 'border-color: var(--ssd-primary); border-width: 2px;' : ''; ?>">
			<div class="ssd-section-header" style="<?php echo $scanner_active ? 'background: linear-gradient(135deg, var(--ssd-primary) 0%, var(--ssd-primary-dark, #6c21a8) 100%); color: white;' : ''; ?>" onclick="toggleSection('cookie-scanner-panel')">
				<h2 style="<?php echo $scanner_active ? 'color: white;' : ''; ?>">
					<span class="dashicons dashicons-search" style="margin-right: 8px;"></span>
					Cookie-Scanner
					<?php if ($scanner_active) : ?>
						<span style="font-size: 12px; font-weight: normal; background: rgba(255,255,255,0.2); padding: 3px 10px; border-radius: 10px; margin-left: 10px;">AKTIV</span>
					<?php endif; ?>
				</h2>
				<span class="ssd-toggle dashicons dashicons-arrow-down-alt2" style="<?php echo $scanner_active ? 'color: white;' : ''; ?>"></span>
			</div>
			<div class="ssd-section-content">

				<!-- Info Box -->
				<div class="ssd-info-box">
					<h3><span class="dashicons dashicons-info"></span> Was macht der Scanner?</h3>
					<p>Der Cookie-Scanner zeigt dir alle Cookies, die im Frontend gesetzt werden. <strong>Keine Sorge:</strong> Nicht jeder Cookie ist problematisch!</p>

					<p><strong>So liest du die Ergebnisse:</strong></p>
					<ul>
						<li><span class="ssd-badge ssd-badge-success">✓ OK</span> = <strong>Unbedenklich</strong> – WordPress-Cookies und dieses Plugin. Kein Handlungsbedarf.</li>
						<li><span class="ssd-badge ssd-badge-danger">⚠ Tracking</span> = <strong>Nur nach Zustimmung erlaubt!</strong> Prüfe, ob diese erst nach Klick auf "Zustimmen" erscheinen.</li>
						<li><span class="ssd-badge ssd-badge-info">? Unbekannt</span> = Cookie nicht in unserer Datenbank. Prüfe, woher er kommt.</li>
					</ul>

					<p><strong>Test-Tipp:</strong> Lösche zuerst deine Cookies (Strg+Shift+Entf im Browser), starte dann den Scan und klicke im Banner auf "Ablehnen". Tracking-Cookies sollten dann NICHT erscheinen.</p>
				</div>

				<!-- Scanner Toggle Box -->
				<?php if ($scanner_active) : ?>
					<div class="ssd-info-box" style="margin-top: 20px; background: #fef2f2; border-color: #fca5a5;">
						<div style="display: flex; align-items: center; justify-content: space-between; flex-wrap: wrap; gap: 15px;">
							<div>
								<h4 style="margin: 0 0 5px 0; color: #dc2626;">
									<span class="dashicons dashicons-warning"></span> Scanner ist aktiv!
								</h4>
								<p style="margin: 0; font-size: 13px; color: #666;">Der Scanner läuft auf deiner Website für alle Admins.</p>
							</div>
							<button type="button" id="abw-toggle-scanner" class="button" style="background: #dc2626; color: white; border-color: #dc2626;">
								<span class="dashicons dashicons-no" style="margin-top: 3px;"></span>
								Scanner deaktivieren
							</button>
						</div>
					</div>
				<?php else : ?>
					<div class="ssd-info-box" style="margin-top: 20px; background: #f0fdf4; border-color: #86efac;">
						<div style="display: flex; align-items: center; justify-content: space-between; flex-wrap: wrap; gap: 15px;">
							<div>
								<h4 style="margin: 0 0 5px 0; color: #059669;">
									<span class="dashicons dashicons-saved"></span> Scanner ist deaktiviert
								</h4>
								<p style="margin: 0; font-size: 13px; color: #666;">Aktiviere ihn, um Cookies auf deiner Website zu prüfen.</p>
							</div>
							<button type="button" id="abw-toggle-scanner" class="button button-primary" style="background: #059669; border-color: #059669;">
								<span class="dashicons dashicons-search" style="margin-top: 3px;"></span>
								Scanner aktivieren
							</button>
						</div>
					</div>
				<?php endif; ?>

				<?php if ($scanner_active) : ?>
					<!-- Scanner Actions -->
					<div class="ssd-scanner-actions" style="margin-top: 20px;">
						<a href="<?php echo esc_url(add_query_arg('abw_cookie_scan', '1', get_home_url())); ?>"
							target="_blank"
							class="button button-primary ssd-btn-primary">
							<span class="dashicons dashicons-search" style="margin-top: 3px;"></span>
							Frontend-Scan starten
						</a>
						<button type="button" id="abw-clear-scan-results" class="button ssd-btn-secondary">
							<span class="dashicons dashicons-trash" style="margin-top: 3px;"></span>
							Ergebnisse löschen
						</button>
					</div>
				<?php endif; ?>

				<?php if ($scanner_active) :
					$current_user_id = get_current_user_id();
					$scan_data = get_user_meta($current_user_id, 'abw_ssd_cookie_scan_last', true);
				?>

					<?php if (!empty($scan_data) && is_array($scan_data)) : ?>
						<div id="cookie-scan-results" style="margin-top: 25px;">
							<h3>Letzter Scan</h3>
							<p>
								<span class="ssd-badge ssd-badge-info">
									<span class="dashicons dashicons-calendar-alt"></span>
									<?php echo esc_html(isset($scan_data['timestamp']) ? $scan_data['timestamp'] : 'Unbekannt'); ?>
								</span>
								<span class="ssd-badge ssd-badge-info" style="margin-left: 10px;">
									<span class="dashicons dashicons-admin-links"></span>
									<?php echo esc_html(isset($scan_data['url']) ? parse_url($scan_data['url'], PHP_URL_PATH) : '/'); ?>
								</span>
							</p>

							<?php if (!empty($scan_data['events'])) :
								// Sortiere: Tracking zuerst, dann unbekannt, dann OK
								$that = $this;
								usort($scan_data['events'], function ($a, $b) use ($that) {
									$info_a = $that->get_cookie_info($a['name']);
									$info_b = $that->get_cookie_info($b['name']);
									$order_a = isset($info_a['tracking']) && $info_a['tracking'] ? 0 : ($info_a['safe'] === null ? 1 : 2);
									$order_b = isset($info_b['tracking']) && $info_b['tracking'] ? 0 : ($info_b['safe'] === null ? 1 : 2);
									return $order_a - $order_b;
								});
							?>
								<table class="widefat" style="margin-top: 15px;">
									<thead>
										<tr>
											<th style="width: 90px;">Status</th>
											<th style="width: 110px;">Kategorie</th>
											<th>Cookie</th>
											<th>Beschreibung</th>
											<th style="width: 80px;">Dauer</th>
										</tr>
									</thead>
									<tbody>
										<?php foreach ($scan_data['events'] as $event) :
											$cookie_info = $this->get_cookie_info($event['name']);
											$is_safe = $cookie_info['safe'];
											$is_tracking = isset($cookie_info['tracking']) && $cookie_info['tracking'];
											$duration = isset($cookie_info['duration']) ? $cookie_info['duration'] : '–';
										?>
											<tr style="<?php echo $is_safe === true ? 'background: #f0fdf4;' : ($is_tracking ? 'background: #fef2f2;' : ''); ?>">
												<td>
													<?php if ($is_safe === true) : ?>
														<span class="ssd-badge ssd-badge-success">✓ OK</span>
													<?php elseif ($is_tracking) : ?>
														<span class="ssd-badge ssd-badge-danger">⚠ Tracking</span>
													<?php else : ?>
														<span class="ssd-badge ssd-badge-info">? Prüfen</span>
													<?php endif; ?>
												</td>
												<td>
													<span style="font-size: 12px; color: #666;"><?php echo esc_html($cookie_info['category']); ?></span>
												</td>
												<td>
													<code style="font-size: 11px;"><?php echo esc_html($event['name']); ?></code>
													<?php if ($event['action'] === 'added') : ?>
														<span style="color: green; font-size: 10px; margin-left: 5px;">NEU</span>
													<?php elseif ($event['action'] === 'changed') : ?>
														<span style="color: orange; font-size: 10px; margin-left: 5px;">↻</span>
													<?php endif; ?>
												</td>
												<td>
													<span style="font-size: 12px; color: #444;"><?php echo esc_html($cookie_info['desc']); ?></span>
													<?php if ($cookie_info['safe'] === null) : ?>
														<br><small style="color: #999;">Wert: <?php echo esc_html($event['valueMasked']); ?></small>
													<?php endif; ?>
												</td>
												<td style="font-size: 11px; color: #888;"><?php echo esc_html($duration); ?></td>
											</tr>
										<?php endforeach; ?>
									</tbody>
								</table>

								<!-- Legende -->
								<div style="margin-top: 15px; padding: 12px 15px; background: #f8f9fa; border-radius: 6px; font-size: 13px;">
									<strong>Legende:</strong>
									<span class="ssd-badge ssd-badge-success" style="margin-left: 15px;">✓ OK</span> = Unbedenklich (WordPress/Plugin)
									<span class="ssd-badge ssd-badge-danger" style="margin-left: 15px;">⚠ Tracking</span> = Tracking-Cookie (nur nach Zustimmung!)
									<span class="ssd-badge ssd-badge-info" style="margin-left: 15px;">? Unbekannt</span> = Nicht in Datenbank
								</div>

								<p style="margin-top: 15px;">
									<label style="cursor: pointer;">
										<input type="checkbox" id="toggle-cookie-values">
										<span>Cookie-Werte vollständig anzeigen</span>
									</label>
								</p>
							<?php else : ?>
								<div class="ssd-info-box" style="margin-top: 15px;">
									<p><em>Keine Cookie-Änderungen während des Scans erkannt.</em></p>
								</div>
							<?php endif; ?>
						</div>
					<?php else : ?>
						<div class="ssd-info-box" style="margin-top: 20px;">
							<p><strong>Noch kein Scan durchgeführt.</strong></p>
							<p>Klicke auf „Frontend-Scan starten", um deine Website zu öffnen. Dort kannst du den Scan starten, mit dem Cookie-Banner interagieren und dann das Ergebnis hier ansehen.</p>
						</div>
					<?php endif; ?>
				<?php endif; /* end $scanner_active for scan results */ ?>
			</div>
		</div>

		<script>
			(function() {
				// Toggle Cookie-Werte anzeigen
				var toggleCheckbox = document.getElementById('toggle-cookie-values');
				if (toggleCheckbox) {
					toggleCheckbox.addEventListener('change', function() {
						var maskedEls = document.querySelectorAll('.cookie-value-masked');
						var rawEls = document.querySelectorAll('.cookie-value-raw');
						maskedEls.forEach(function(el) {
							el.style.display = toggleCheckbox.checked ? 'none' : 'inline';
						});
						rawEls.forEach(function(el) {
							el.style.display = toggleCheckbox.checked ? 'inline' : 'none';
						});
					});
				}

				// Scan-Ergebnisse löschen
				var clearBtn = document.getElementById('abw-clear-scan-results');
				if (clearBtn) {
					clearBtn.addEventListener('click', function() {
						if (!confirm('Scan-Ergebnisse wirklich löschen?')) return;

						var xhr = new XMLHttpRequest();
						xhr.open('POST', ajaxurl, true);
						xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
						xhr.onreadystatechange = function() {
							if (xhr.readyState === 4) {
								if (xhr.status === 200) {
									location.reload();
								} else {
									alert('Fehler beim Löschen.');
								}
							}
						};
						xhr.send('action=abw_ssd_clear_cookie_scan&_wpnonce=<?php echo wp_create_nonce('abw_ssd_cookie_scan'); ?>');
					});
				}

				// Scanner aktivieren/deaktivieren Toggle
				var toggleBtn = document.getElementById('abw-toggle-scanner');
				if (toggleBtn) {
					toggleBtn.addEventListener('click', function() {
						var btn = this;
						var isCurrentlyActive = <?php echo $scanner_active ? 'true' : 'false'; ?>;
						var action = isCurrentlyActive ? 'abw_ssd_disable_cookie_scanner' : 'abw_ssd_enable_cookie_scanner';

						btn.disabled = true;
						btn.innerHTML = '<span class="dashicons dashicons-update spin" style="margin-top: 3px; animation: spin 1s linear infinite;"></span> Bitte warten...';

						var xhr = new XMLHttpRequest();
						xhr.open('POST', ajaxurl, true);
						xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
						xhr.onreadystatechange = function() {
							if (xhr.readyState === 4) {
								if (xhr.status === 200) {
									location.reload();
								} else {
									alert('Fehler beim Ändern der Einstellung.');
									btn.disabled = false;
									btn.innerHTML = isCurrentlyActive ?
										'<span class="dashicons dashicons-no" style="margin-top: 3px;"></span> Scanner deaktivieren' :
										'<span class="dashicons dashicons-search" style="margin-top: 3px;"></span> Scanner aktivieren';
								}
							}
						};
						xhr.send('action=' + action + '&_wpnonce=<?php echo wp_create_nonce('abw_ssd_cookie_scan'); ?>');
					});
				}
			})();
		</script>
		<style>
			@keyframes spin {
				from {
					transform: rotate(0deg);
				}

				to {
					transform: rotate(360deg);
				}
			}
		</style>
<?php
	}
}

new supersimpeldsgvo_Settings_Page();

// AJAX Handler für Cookie-Scanner
add_action('wp_ajax_abw_ssd_save_cookie_scan', 'abw_ssd_save_cookie_scan_handler');
function abw_ssd_save_cookie_scan_handler()
{
	if (!current_user_can('manage_options')) {
		wp_send_json_error('Keine Berechtigung', 403);
	}

	if (!isset($_POST['_wpnonce']) || !wp_verify_nonce($_POST['_wpnonce'], 'abw_ssd_cookie_scan')) {
		wp_send_json_error('Ungültiger Nonce', 403);
	}

	$scan_data = isset($_POST['scan_data']) ? $_POST['scan_data'] : null;

	if (!$scan_data || !is_array($scan_data)) {
		wp_send_json_error('Ungültige Daten', 400);
	}

	$sanitized = [
		'timestamp' => isset($scan_data['timestamp']) ? sanitize_text_field($scan_data['timestamp']) : '',
		'url' => isset($scan_data['url']) ? esc_url_raw($scan_data['url']) : '',
		'events' => []
	];

	if (isset($scan_data['events']) && is_array($scan_data['events'])) {
		foreach ($scan_data['events'] as $event) {
			if (!is_array($event)) continue;

			$sanitized['events'][] = [
				'action' => isset($event['action']) ? sanitize_text_field($event['action']) : '',
				'name' => isset($event['name']) ? sanitize_text_field($event['name']) : '',
				'valueMasked' => isset($event['valueMasked']) ? sanitize_text_field($event['valueMasked']) : '',
				'valueRaw' => isset($event['valueRaw']) ? sanitize_text_field($event['valueRaw']) : '',
				'time' => isset($event['time']) ? sanitize_text_field($event['time']) : ''
			];
		}
	}

	if (count($sanitized['events']) > 100) {
		$sanitized['events'] = array_slice($sanitized['events'], 0, 100);
	}

	$user_id = get_current_user_id();
	update_user_meta($user_id, 'abw_ssd_cookie_scan_last', $sanitized);

	wp_send_json_success('Scan gespeichert');
}

add_action('wp_ajax_abw_ssd_clear_cookie_scan', 'abw_ssd_clear_cookie_scan_handler');
function abw_ssd_clear_cookie_scan_handler()
{
	if (!current_user_can('manage_options')) {
		wp_send_json_error('Keine Berechtigung', 403);
	}

	if (!isset($_POST['_wpnonce']) || !wp_verify_nonce($_POST['_wpnonce'], 'abw_ssd_cookie_scan')) {
		wp_send_json_error('Ungültiger Nonce', 403);
	}

	$user_id = get_current_user_id();
	delete_user_meta($user_id, 'abw_ssd_cookie_scan_last');

	wp_send_json_success('Scan gelöscht');
}

// AJAX Handler zum Deaktivieren des Cookie-Scanners
add_action('wp_ajax_abw_ssd_disable_cookie_scanner', 'abw_ssd_disable_cookie_scanner_handler');
function abw_ssd_disable_cookie_scanner_handler()
{
	if (!current_user_can('manage_options')) {
		wp_send_json_error('Keine Berechtigung', 403);
	}

	if (!isset($_POST['_wpnonce']) || !wp_verify_nonce($_POST['_wpnonce'], 'abw_ssd_cookie_scan')) {
		wp_send_json_error('Ungültiger Nonce', 403);
	}

	// Scanner-Option deaktivieren
	update_option('ssd_cookie_scanner_debug', '0');

	wp_send_json_success('Scanner deaktiviert');
}

// AJAX Handler zum Aktivieren des Cookie-Scanners
add_action('wp_ajax_abw_ssd_enable_cookie_scanner', 'abw_ssd_enable_cookie_scanner_handler');
function abw_ssd_enable_cookie_scanner_handler()
{
	if (!current_user_can('manage_options')) {
		wp_send_json_error('Keine Berechtigung', 403);
	}

	if (!isset($_POST['_wpnonce']) || !wp_verify_nonce($_POST['_wpnonce'], 'abw_ssd_cookie_scan')) {
		wp_send_json_error('Ungültiger Nonce', 403);
	}

	// Scanner-Option aktivieren
	update_option('ssd_cookie_scanner_debug', '1');

	wp_send_json_success('Scanner aktiviert');
}
